#include "stdafx.h"
#include "win_demo.h"
#include "DialogStreamParam.h"
#include "afxdialogex.h"
#include "common_struct.h"
#include "sdks.h"
#include "perser_json.h"
#include "pack_json.h"
#include "win_demoDlg.h"

IMPLEMENT_DYNAMIC(CDialogStreamParam, CDialogEx)
extern int m_handle;
extern int m_chn_option;
CDialogStreamParam::CDialogStreamParam(CWnd* pParent)
	: CDialogEx(IDD_WIN_STREAM_PARAM, pParent)
{
	
}

CDialogStreamParam::~CDialogStreamParam()
{
}

jy_get_av_stream_res_t stAVStream = { 0 };
jy_video_ability_param_list_t stVideoParamList = { 0 };
jy_video_param_list_t stParamList = { 0 };
BOOL CDialogStreamParam::OnInitStreamParam()
{
	int i, j, b, n = 0;
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	jy_stream_param_t stStreamParam = { 0 };
	nRet = sdks_dev_get_video_cap(m_handle, m_chn_option, &p_result);
	if (0 == nRet)
	{
		json_perser_video_cap(p_result, &stVideoParamList);
	}
	nRet = sdks_get_video_param(m_handle, m_chn_option, &p_result);
	if (0 == nRet)
	{
		json_perser_av_stream(p_result, &stAVStream);
		if (stAVStream.stream_num > 0)
		{
			stStreamParam.chn_list[0] = stAVStream.stream[0].channel_id;
			stStreamParam.id_list[0] = stAVStream.stream[0].stream_id;
			for (i = 1, n = 1; i < stAVStream.stream_num; ++i)
			{
				for (j = 0, b = 0; j < i; ++j)
				{
					if (stAVStream.stream[i].stream_id == stAVStream.stream[j].stream_id)
					{
						b = 1;
						break;
					}
				}
				if (0 == b)
				{
					stStreamParam.id_list[n] = stAVStream.stream[i].stream_id;
					++n;
				}
				stStreamParam.id_num = n;
			}
			for (i = 1, n = 1; i < stAVStream.stream_num; ++i)
			{
				for (j = 0, b = 0; j < i; ++j)
				{
					if (stAVStream.stream[i].channel_id == stAVStream.stream[j].channel_id)
					{
						b = 1;
						break;
					}
				}
				if (0 == b)
				{
					stStreamParam.chn_list[n] = stAVStream.stream[i].channel_id;
					++n;
				}
				stStreamParam.chn_num = n;
			}
		}
	}

	for (i = 0; i < stStreamParam.chn_num; ++i)
	{
		strins.Format(_T("%d"), stStreamParam.chn_list[i]);
		m_stream_param_chn.AddString(strins);
	}
	m_stream_param_chn.SetCurSel(0);

	for (i = 0; i < stStreamParam.id_num; ++i)
	{
		strins.Format(_T("%d"), stStreamParam.id_list[i]);
		m_stream_param_id.AddString(strins);
	}
	m_stream_param_id.SetCurSel(0);
	m_stream_param_bit_type.AddString(TEXT("CBR"));
	m_stream_param_bit_type.AddString(TEXT("VBR"));
	m_stream_param_bit_type.SetCurSel(0);
	m_stream_param_quality.AddString(TEXT("1"));
	m_stream_param_quality.AddString(TEXT("2"));
	m_stream_param_quality.AddString(TEXT("3"));
	m_stream_param_quality.AddString(TEXT("4"));
	m_stream_param_quality.AddString(TEXT("5"));
	m_stream_param_quality.AddString(TEXT("6"));
	m_stream_param_quality.AddString(TEXT("7"));
	m_stream_param_quality.AddString(TEXT("8"));
	m_stream_param_quality.AddString(TEXT("9"));
	m_stream_param_quality.SetCurSel(4);
	m_stream_param_a_enc.InsertString(0, TEXT("G711_ALAW"));
	m_stream_param_a_enc.InsertString(1, TEXT("G711_ULAW"));
	m_stream_param_a_enc.InsertString(2, TEXT("RAW_PCM"));
	m_stream_param_a_enc.InsertString(3, TEXT("NONE"));
	m_stream_param_a_enc.SetCurSel(0);
	OnCBnDropdownStreamChnOrId();
	return TRUE;
}

void CDialogStreamParam::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CHN, m_stream_param_chn);
	DDX_Control(pDX, IDC_COMBO_STREAM_ID, m_stream_param_id);
	DDX_Control(pDX, IDC_EDIT_STREAM_NAME, m_stream_param_name);
	DDX_Control(pDX, IDC_COMBO_RESOLUTION, m_stream_resolution);
	DDX_Control(pDX, IDC_COMBO_V_FPS, m_stream_param_fps);
	DDX_Control(pDX, IDC_COMBO_BIT_TYPE, m_stream_param_bit_type);
	DDX_Control(pDX, IDC_EDIT_V_BPS, m_stream_param_bps);
	DDX_Control(pDX, IDC_COMBO_V_QUALITY, m_stream_param_quality);
	DDX_Control(pDX, IDC_COMBO_V_IF_INT, m_stream_param_if_int);
	DDX_Control(pDX, IDC_COMBO_V_ENC, m_stream_param_v_enc);
	DDX_Control(pDX, IDC_COMBO_V_ENC_LEVEL, m_stream_param_v_enc_level);
	DDX_Control(pDX, IDC_COMBO_A_ENC, m_stream_param_a_enc);
}

BEGIN_MESSAGE_MAP(CDialogStreamParam, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_CHN, &CDialogStreamParam::OnCBnDropdownStreamChnOrId)
	ON_CBN_SELCHANGE(IDC_COMBO_STREAM_ID, &CDialogStreamParam::OnCBnDropdownStreamChnOrId)
	ON_CBN_SELCHANGE(IDC_COMBO_V_ENC, &CDialogStreamParam::OnCBnDropdownSetStreamEncType)
	ON_CBN_SELCHANGE(IDC_COMBO_RESOLUTION, &CDialogStreamParam::OnCBnDropdownSetResolution)
	ON_BN_CLICKED(IDOK, &CDialogStreamParam::OnBnClickedOk)
END_MESSAGE_MAP()

void CDialogStreamParam::OnCBnDropdownStreamChnOrId()
{
	CString str_chn;
	CString str_id;
	CString strins;
	int chn_index = m_stream_param_chn.GetCurSel();
	int id_index = m_stream_param_id.GetCurSel();
	m_stream_param_chn.GetLBText(chn_index, str_chn);
	m_stream_param_id.GetLBText(id_index, str_id);
	int chn_id = _ttoi(str_chn);
	int stream_id = _ttoi(str_id);
	m_stream_param_v_enc.ResetContent();
	memset(&stParamList, 0, sizeof(jy_video_param_list_t));
	for (int i = 0; i < stVideoParamList.param_num; ++i)
	{
		if (chn_id == stVideoParamList.video_param[i].channel_id)
		{
			for (int j = 0; j < stVideoParamList.video_param[i].base_stream_num; ++j)
			{
				if (stream_id == stVideoParamList.video_param[i].base_stream_list[j].stream_id)
				{
					for (int k = 0; k < stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_num; ++k)
					{
						m_stream_param_v_enc.InsertString(k, stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].enc_type_name);
						stParamList.video_param[k].num = k;
						stParamList.video_param[k].type = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].video_enc_type;
						++stParamList.video_num;
					}
				}
			}
		}
	}

	for (int i = 0; i < stAVStream.stream_num; ++i)
	{
		if ((chn_id == stAVStream.stream[i].channel_id) && (stream_id == stAVStream.stream[i].stream_id))
		{
			m_stream_param_name.SetWindowTextA(stAVStream.stream[i].stream_name);
			//strins.Format(_T("%d"), stAVStream.stream[i].frame_rate);
			//m_stream_param_fps.SetWindowTextA(strins);
			m_stream_param_bit_type.SetCurSel(stAVStream.stream[i].bit_rate_type - 1);
			strins.Format(_T("%d"), stAVStream.stream[i].bit_rate);
			m_stream_param_bps.SetWindowTextA(strins);
			m_stream_param_quality.SetCurSel(stAVStream.stream[i].quality - 1);
			//strins.Format(_T("%d"), stAVStream.stream[i].i_frame_interval);
			//m_stream_param_if_int.SetWindowTextA(strins);
			strins.Format(_T("%d"), stAVStream.stream[i].i_frame_interval_unit);
			for (int j = 0; j < stParamList.video_num; ++j)
			{
				if (stAVStream.stream[i].video_encoder_type == stParamList.video_param[j].type)
				{
					m_stream_param_v_enc.SetCurSel(j);
				}
			}
			if (102 == stAVStream.stream[i].audio_encoder_type)
			{
				m_stream_param_a_enc.SetCurSel(0);
			}
			else if (103 == stAVStream.stream[i].audio_encoder_type)
			{
				m_stream_param_a_enc.SetCurSel(1);
			}
			else if (108 == stAVStream.stream[i].audio_encoder_type)
			{
				m_stream_param_a_enc.SetCurSel(2);
			}
			else
			{
				m_stream_param_a_enc.SetCurSel(4);
			}
		}
	}
	OnCBnDropdownSetStreamEncType();
}

void CDialogStreamParam::OnCBnDropdownSetStreamEncType()
{
	CString str_chn;
	CString str_id;
	int chn_index = m_stream_param_chn.GetCurSel();
	int id_index = m_stream_param_id.GetCurSel();
	m_stream_param_chn.GetLBText(chn_index, str_chn);
	m_stream_param_id.GetLBText(id_index, str_id);
	int chn_id = _ttoi(str_chn);
	int stream_id = _ttoi(str_id);
	CString str_en_type;
	int chn_env_index = m_stream_param_v_enc.GetCurSel();
	for (int i = 0; i < stParamList.video_num; ++i)
	{
		if (chn_env_index == stParamList.video_param[i].num)
		{
			m_stream_type = stParamList.video_param[i].type;
		}
	}
	m_stream_param_v_enc_level.ResetContent();
	m_stream_resolution.ResetContent();
	for (int i = 0; i < stVideoParamList.param_num; ++i)
	{
		if (chn_id == stVideoParamList.video_param[i].channel_id)
		{
			for (int j = 0; j < stVideoParamList.video_param[i].base_stream_num; ++j)
			{
				if (stream_id == stVideoParamList.video_param[i].base_stream_list[j].stream_id)
				{
					for (int k = 0; k < stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_num; ++k)
					{
						if (m_stream_type == stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].video_enc_type)
						{
							for (int n = 0; n < stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_num; ++n)
							{
								if (1 == stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_list[n].encoder_level)
								{
									m_stream_param_v_enc_level.InsertString(n, TEXT("Low"));
								}
								else if (2 == stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_list[n].encoder_level)
								{
									m_stream_param_v_enc_level.InsertString(n, TEXT("Middle"));
								}
								else if (3 == stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_list[n].encoder_level)
								{
									m_stream_param_v_enc_level.InsertString(n, TEXT("High"));
								}
								else
								{
									m_stream_param_v_enc_level.InsertString(n, TEXT("None"));
								}
								stParamList.env_level[n].num = n;
								stParamList.env_level[n].level = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].enc_level_list[n].encoder_level;
								++stParamList.level_num;
							}
							for (int m = 0; m < stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_num; ++m)
							{
								m_stream_resolution.InsertString(m, stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].size_name);
								stParamList.base_param[m].num = m;
								strcpy(stParamList.base_param[m].base_cap.size_name, stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].size_name);
								stParamList.base_param[m].base_cap.width = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].width;
								stParamList.base_param[m].base_cap.height = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].height;
								stParamList.base_param[m].base_cap.max_fps = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].max_fps;
								stParamList.base_param[m].base_cap.min_fps = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].min_fps;
								stParamList.base_param[m].base_cap.max_bps = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].max_bps;
								stParamList.base_param[m].base_cap.min_bps = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].min_bps;
								stParamList.base_param[m].base_cap.max_qul = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].max_qul;
								stParamList.base_param[m].base_cap.min_qul = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].min_qul;
								stParamList.base_param[m].base_cap.max_inval = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].max_inval;
								stParamList.base_param[m].base_cap.min_inval = stVideoParamList.video_param[i].base_stream_list[j].video_enc_param_list[k].base_cap_list[m].min_inval;
								++stParamList.base_num;
							}
						}
					}
				}
			}
		}
	}
	m_stream_param_v_enc_level.SetCurSel(0);
	m_stream_resolution.SetCurSel(0);
	for (int i = 0; i < stVideoParamList.param_num; ++i)
	{
		for (int j = 0; j < stParamList.level_num; ++j)
		{
			if (stAVStream.stream[i].video_encode_level == stParamList.env_level[j].level)
			{
				m_stream_param_v_enc_level.SetCurSel(j);
			}
		}
		for (int j = 0; j < stParamList.base_num; ++j)
		{
			if ((stAVStream.stream[i].video_width == stParamList.base_param[j].base_cap.width) && (stAVStream.stream[i].video_height == stParamList.base_param[j].base_cap.height))
			{
				m_stream_resolution.SetCurSel(j);
			}
		}
	}
	OnCBnDropdownSetResolution();
}

void CDialogStreamParam::OnCBnDropdownSetResolution()
{
	m_stream_param_fps.ResetContent();
	m_stream_param_if_int.ResetContent();
	CString str_resolition;
	CString strins;
	int choose_width = 0;
	int choose_height = 0;
	int chn_res_index = m_stream_resolution.GetCurSel();
	m_stream_resolution.GetLBText(chn_res_index, str_resolition);
	sscanf(str_resolition, "%dx%d", &choose_width, &choose_height);
	if ((choose_width <= 0) && (choose_height <= 0))
	{
		sscanf(str_resolition, "%d*%d", &choose_width, &choose_height);
	}
	if ((choose_width <= 0) && (choose_height <= 0))
	{
		if (!strcmp(str_resolition, "D1"))
		{
			choose_width = 704;
			choose_height = 576;
		}
		else if (!strcmp(str_resolition, "VGA"))
		{
			choose_width = 640;
			choose_height = 480;
		}
		else if (!strcmp(str_resolition, "CIF"))
		{
			choose_width = 352;
			choose_height = 288;
		}
		else if (!strcmp(str_resolition, "QVGA"))
		{
			choose_width = 320;
			choose_height = 240;
		}
		else
		{
			choose_width = 1280;
			choose_height = 720;
		}
	}
	for (int i = 0; i < stParamList.base_num; ++i)
	{
		if ((choose_width == stParamList.base_param[i].base_cap.width) && (choose_height == stParamList.base_param[i].base_cap.height))
		{
			if (stParamList.base_param[i].base_cap.max_fps > 0)
			{
				for (int j = 0; j < stParamList.base_param[i].base_cap.max_fps; ++j)
				{
					strins.Format(_T("%d"), j + 1);
					m_stream_param_fps.InsertString(j, strins);
					m_stream_param_fps.SetCurSel(j);
				}
				if (stParamList.base_param[i].base_cap.max_fps >= 25)
				{
					m_stream_param_fps.SetCurSel(24);
				}
			}
			else
			{
				m_stream_param_fps.AddString(TEXT("0"));
				m_stream_param_fps.SetCurSel(0);
			}
			if (stParamList.base_param[i].base_cap.max_inval > 0)
			{
				for (int j = 0; j < stParamList.base_param[i].base_cap.max_inval; ++j)
				{
					strins.Format(_T("%d"), j + 1);
					m_stream_param_if_int.InsertString(j, strins);
					m_stream_param_if_int.SetCurSel(j);
				}
				if (stParamList.base_param[i].base_cap.max_inval >= 25)
				{
					m_stream_param_if_int.SetCurSel(24);
				}
			}
			else
			{
				m_stream_param_if_int.AddString(TEXT("0"));
				m_stream_param_if_int.SetCurSel(0);
			}
		}
	}
	for (int i = 0; i < stVideoParamList.param_num; ++i)
	{
		for (int j = 0; j < stParamList.base_num; ++j)
		{
			if ((stAVStream.stream[i].video_width == stParamList.base_param[j].base_cap.width) && (stAVStream.stream[i].video_height == stParamList.base_param[j].base_cap.height))
			{
				m_stream_param_fps.SetCurSel(stAVStream.stream[i].frame_rate - 1);
				m_stream_param_if_int.SetCurSel(stAVStream.stream[i].i_frame_interval - 1);
			}
		}
	}
}

void CDialogStreamParam::OnBnClickedOk()
{
	CDialogEx::OnOK();
	CString str_chn;
	CString str_id;
	CString str_tmp;
	int tmp_index;
	char *p_param = NULL;
	int choose_width = 0;
	int choose_height = 0;
	int max_bps = 0;
	int min_bps = 0;
	int chn_index = m_stream_param_chn.GetCurSel();
	int id_index = m_stream_param_id.GetCurSel();
	m_stream_param_chn.GetLBText(chn_index, str_chn);
	m_stream_param_id.GetLBText(id_index, str_id);
	int chn_id = _ttoi(str_chn);
	int stream_id = _ttoi(str_id);
	for (int i = 0; i < stAVStream.stream_num; ++i)
	{
		if ((chn_id == stAVStream.stream[i].channel_id) && (stream_id == stAVStream.stream[i].stream_id))
		{
			m_stream_param_name.GetWindowText(str_tmp);
			strcpy(stAVStream.stream[i].stream_name, str_tmp);
			tmp_index = m_stream_param_v_enc.GetCurSel();
			m_stream_param_v_enc.GetLBText(tmp_index, str_tmp);
			if (!strcmp(str_tmp, "H264"))
			{
				stAVStream.stream[i].video_encoder_type = 1;
				tmp_index = m_stream_param_v_enc_level.GetCurSel();
				stAVStream.stream[i].video_encode_level = tmp_index;
			}
			else if (!strcmp(str_tmp, "MJPEG"))
			{
				stAVStream.stream[i].video_encoder_type = 2;
				stAVStream.stream[i].video_encode_level = 0;
			}
			else
			{
				stAVStream.stream[i].video_encoder_type = 8;
				stAVStream.stream[i].video_encode_level = 1;
			}

			tmp_index = m_stream_param_a_enc.GetCurSel();
			if (0 == tmp_index)
			{
				stAVStream.stream[i].audio_encoder_type = 102;
			}
			else if (1 == tmp_index)
			{
				stAVStream.stream[i].audio_encoder_type = 103;
			}
			else if (2 == tmp_index)
			{
				stAVStream.stream[i].audio_encoder_type = 108;
			}
			else
			{
				stAVStream.stream[i].audio_encoder_type = 109;
			}
			tmp_index = m_stream_resolution.GetCurSel();
			m_stream_resolution.GetLBText(tmp_index, str_tmp);
			sscanf(str_tmp, "%dx%d", &choose_width, &choose_height);
			if ((choose_width <= 0) && (choose_height <= 0))
			{
				sscanf(str_tmp, "%d*%d", &choose_width, &choose_height);
			}
			if ((choose_width <= 0) && (choose_height <= 0))
			{
				if (!strcmp(str_tmp, "D1"))
				{
					choose_width = 704;
					choose_height = 576;
				}
				else if (!strcmp(str_tmp, "VGA"))
				{
					choose_width = 640;
					choose_height = 480;
				}
				else if (!strcmp(str_tmp, "CIF"))
				{
					choose_width = 352;
					choose_height = 288;
				}
				else if (!strcmp(str_tmp, "QVGA"))
				{
					choose_width = 320;
					choose_height = 240;
				}
				else
				{
					choose_width = 1280;
					choose_height = 720;
				}
			}
			stAVStream.stream[i].video_width = choose_width;
			stAVStream.stream[i].video_height = choose_height;
			tmp_index = m_stream_param_fps.GetCurSel();
			m_stream_param_fps.GetLBText(tmp_index, str_tmp);
			stAVStream.stream[i].frame_rate = _ttoi(str_tmp);
			tmp_index = m_stream_param_if_int.GetCurSel();
			m_stream_param_if_int.GetLBText(tmp_index, str_tmp);
			stAVStream.stream[i].i_frame_interval = _ttoi(str_tmp);
			tmp_index = m_stream_param_bit_type.GetCurSel();
			stAVStream.stream[i].bit_rate_type = tmp_index + 1;
			m_stream_param_bps.GetWindowText(str_tmp);
			tmp_index = _ttoi(str_tmp);
			for (int j = 0; j < stParamList.base_num; ++j)
			{
				if ((choose_width == stParamList.base_param[j].base_cap.width) && ((choose_height == stParamList.base_param[j].base_cap.height)))
				{
					max_bps = stParamList.base_param[j].base_cap.max_bps;
					min_bps = stParamList.base_param[j].base_cap.min_bps;
				}
			}
			if ((tmp_index > max_bps) || (tmp_index < min_bps))
			{
				MessageBoxA("Set bitrate is error!");
				return;
			}
			else
			{
				stAVStream.stream[i].bit_rate = tmp_index;
			}
			tmp_index = m_stream_param_quality.GetCurSel();
			stAVStream.stream[i].quality = tmp_index + 1;
			UINT i = 0;
			i = MessageBoxA(_T("Are you sure you want to set up the video stream?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
			if (IDYES == i)
			{
				pack_json_av_stream(&stAVStream.stream[i], &p_param);
				int nRet = sdks_set_video_param(m_handle, p_param);
				if (nRet) {
					MessageBoxA("Failed to set device encoding format fail!");
				}
			}
		}
	}
}
